/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright (c) 2015 Adobe Systems Incorporated. All rights reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

/*jslint vars: true, node: true, plusplus: true, devel: true, nomen: true, indent: 4, expr:true */
/*global beforeEach: false, afterEach: false, it: false, describe: false, expect: false*/

"use strict";

var Errors = require("../lib/errors"),
    Locale = require("locale");

describe("Errors", function () {
    afterEach(function () {
        // Reset locale strings to reasonable defaults.
        Locale.init("en_US");
    });

    it("FSWriteError should format its message", function () {
        Locale.FS_WRITE_ERROR = "hello {0}";
        expect(new Errors.FSWriteError("some/folder").message).to.equal("hello some/folder");
    });

    it("FSWriteError should not escape its message", function () {
        Locale.FS_WRITE_ERROR = "hello {0}";
        expect(new Errors.FSWriteError("\"\\'").message).to.equal("hello \"\\'");
    });
});
